/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDBasicMenuItemUI;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.border.Border;

public class QDMenuItem
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private boolean m_mouseOver = false;

    public QDMenuItem() {
        this.initLook();
    }

    public QDMenuItem(Icon icon) {
        super(icon);
        this.initLook();
    }

    public QDMenuItem(String string) {
        super(string);
        this.initLook();
    }

    public QDMenuItem(Action action) {
        super(action);
        this.initLook();
    }

    public QDMenuItem(String string, Icon icon) {
        super(string, icon);
        this.initLook();
    }

    public QDMenuItem(String string, int n) {
        super(string, n);
        this.initLook();
    }

    private void initLook() {
        this.setBackground(QDStdUI.getActionBackground());
        if (QDStdUI.g_menuStyle == 0) {
            this.setForeground(Color.black);
        }
        if (QDStdUI.g_menuStyle == 1) {
            this.setForeground(QDStdUI.getActionForeground());
        }
        if (QDStdUI.g_useLargeMenus) {
            Font font = QDStdUI.getActionFont();
            this.setFont(new Font(font.getName(), font.getStyle() | 2, font.getSize()));
        }
        this.setBorder(this.createItemBorder());
        this.setUI(new QDBasicMenuItemUI());
        this.setOpaque(false);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                QDMenuItem.this.m_mouseOver = true;
                QDMenuItem.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                QDMenuItem.this.m_mouseOver = false;
                QDMenuItem.this.repaint();
            }
        });
    }

    private Border createItemBorder() {
        Border border = BorderFactory.createRaisedBevelBorder();
        if (!QDStdUI.g_useLargeMenus) {
            return border;
        }
        int n = QDStdUI.getActionInset();
        Border border2 = BorderFactory.createEmptyBorder(n, n, n, n);
        return BorderFactory.createCompoundBorder(border, border2);
    }

    public void paint(Graphics graphics) {
        if (QDStdUI.g_menuStyle == 0) {
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getButtonLight(), 0.0f, this.getHeight(), QDStdUI.getButtonDark());
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(paint);
            if (this.isEnabled()) {
                if (this.m_mouseOver && !this.isSelected()) {
                    this.setForeground(QDStdUI.getFocusColor());
                } else {
                    this.setForeground(Color.black);
                }
            } else {
                this.setForeground(Color.lightGray);
            }
        }
        if (QDStdUI.g_menuStyle == 1) {
            if (this.isEnabled()) {
                if (this.m_mouseOver && !this.isSelected()) {
                    this.setForeground(QDStdUI.getFocusColor());
                } else {
                    this.setForeground(QDStdUI.getActionForeground());
                }
            } else {
                this.setForeground(Color.lightGray);
            }
        }
        super.paint(graphics);
    }
}

